#include "drawVector.h"


/************************************************************************
/* Name: readVector
/* Function: Read the Vector database.
/* Input: fDir: the directory of the file.
/*        cNum: the index of the character which need to be read.
/*		  cNum_num: the size of index.	
/* Output: dat: the handwriting content of the corresponding characters
/* Return:
/* Explain:
/* Amendant record			
/* Date          Edition       Modifier      Summary
/* 10/12/2009    V1.0          Suqin Ao      Establish 
/************************************************************************/
PointAA *readVector(char *fDirNew, int *cNum, int cNum_num)
{
	int i, j, k, l;
	

	FILE *file_id;
	Point *point;
	PointA *pointa;

	if (!(file_id = fopen(fDirNew, "rb"))) 
	{
		printf("The vector file cannot open!");
		exit(1);
	}
	DWORD iNum;
	fread(&iNum, sizeof(DWORD), 1, file_id);
	int maxIndex;
	maxIndex = myMax(cNum, cNum_num);
	if(maxIndex > (int)iNum)
	{
		printf("Error, the indexs are exceed the number of characters.");
		exit(1);
	}
	/**********Applying Space***********/
	BYTE iLenStr[10000];
	WORD iSpace[10000];
	
	//iLenStr = (BYTE *)malloc(sizeof(BYTE) * iNum);
	//iSpace = (WORD *)malloc(sizeof(WORD) * iNum);

	memset(iLenStr, 0, 10000);
	memset(iSpace, 0, 10000);
	/**********Read the space of every character***********/
	for(i = 0; i < (int)iNum; i ++)
		fread(&iSpace[i], sizeof(WORD), 1, file_id);
	

	/**********Calculate the index of every character***********/
	LONG iIndex[10000];//2B
	//iIndex = (WORD *)malloc(sizeof(WORD) * iNum);
	memset(iLenStr, 0, 10000);

	iIndex[0] = iSpace[0];
	for(i = 1; i < (int)iNum; i ++)
		iIndex[i]=iIndex[i-1]+iSpace[i];

	/**********Read all characters***********/
	BYTE datAll[50000];
	memset(datAll, 0, 50000);
	//datAll = (BYTE *)malloc(sizeof(BYTE) * maxIndex);
	fread(datAll, sizeof(BYTE), iIndex[maxIndex - 1], file_id);
	fclose(file_id);


	/**********extract the characters***********/
	int iCMov;
	int iMovAll;
	int mTemp;
	int iAdd;
	int iStart;

	iLenStr[0] = datAll[0];
	iStart = iLenStr[0] + 1;
	BYTE iSP[300];
	//iSP = (BYTE *)malloc(sizeof(BYTE) * iLenStr[0]);
	for(i = 0; i < iLenStr[0]; i ++)
		iSP[i] = datAll[i + 1];

	

	PointAA *dat;
	dat = (PointAA *)malloc(sizeof(PointAA) * cNum_num);
	dat->num = cNum_num;


	FILE *fp;
	fp = fopen("log_xy.txt", "w");

	for(i = 0; i < cNum_num; i ++)
	{
		if(cNum[i] == 1)
			iAdd = 0;
		else
			iAdd = iIndex[cNum[i] - 2];
		iLenStr[cNum[i] - 1] = datAll[iAdd];
		iCMov = iLenStr[cNum[i] - 1] + 1;
		for(j = 0; j < iLenStr[cNum[i] - 1]; j ++)
			iSP[j] = datAll[j + 1 + iAdd];

		
		

		pointa = (PointA *)malloc(sizeof(PointA) * iLenStr[cNum[i] - 1]);
		pointa->num = iLenStr[cNum[i] - 1];
		
		fprintf(fp, "%d%d\n", i, iLenStr[cNum[i] - 1]);
		for(j = 0; j < iLenStr[cNum[i] - 1]; j ++)
		{
			mTemp = sum(iSP, j - 1) * 2;			
			iMovAll = iAdd + iCMov + mTemp;

			point = (Point *)malloc(sizeof(Point) * iSP[j]);
			point->num = iSP[j];

			fprintf(fp, "%d%d\n", j, iSP[j]);
			l = 0;
			for(k = 0; k < iSP[j] * 2; k += 2)
			{
				point->X[l] = datAll[k + iMovAll];
				point->Y[l] = datAll[k + iMovAll + 1];
				
				fprintf(fp, "x=%d, y=%d\n", point->X[l], point->Y[l]);
				l ++;
			}
			
			pointa->stroke[j] = point;
		}

		dat->PA[i] = pointa;
		//pointa = NULL; 
	}
	fclose(fp);
	return dat;
}

